	function N = CH_ORDER_S(Wc, Ws, Amax, Amin)
	
	% 	Computes the required order for an analog lowpass filter of 
	%	Chebyshev I and II type. 
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 1986-9-27
	% 	Modified by: 	LW, 2000-10-25, 2002-07-28, 2004-09-22, 2013-12-29
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	
	if (Wc >= Ws)
		error('Not a lowpass filter. Must have Wc < Ws')  
	elseif ( Amax <= 0 | Amax >= Amin)
		error('The passband attenuation must be 0 < Amax < Amin')
	elseif ( Amin <= 0)
		error('The stopband attenuation must be Amin > Amax > 0')
	end
	Apn = Amax*log(10)/20;
	N = acosh(sqrt((10^(0.1*Amin)-1)/(2*exp(Apn)*sinh(Apn))))/acosh(Ws/Wc);
	
